﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace NVCC.Models
{
    [Serializable]
    [XmlRoot(ElementName = "dicomUid")]
    public class DicomUid
    {
        [XmlAttribute(AttributeName = "nil", Namespace = "http://www.w3.org/2001/XMLSchema-instance")]
        public string Nil { get; set; }
        [XmlAttribute(AttributeName = "xsi", Namespace = "http://www.w3.org/2000/xmlns/")]
        public string Xsi { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "firstImage")]
    public class FirstImage
    {
        [XmlElement(ElementName = "associatedNoteResulted")]
        public string AssociatedNoteResulted { get; set; }
        [XmlElement(ElementName = "captureDate")]
        public string CaptureDate { get; set; }
        [XmlElement(ElementName = "diagnosticImageUri")]
        public string DiagnosticImageUri { get; set; }
        [XmlElement(ElementName = "dicomImageNumber")]
        public string DicomImageNumber { get; set; }
        [XmlElement(ElementName = "dicomSequenceNumber")]
        public string DicomSequenceNumber { get; set; }
        [XmlElement(ElementName = "dicomUid")]
        public DicomUid DicomUid { get; set; }
        [XmlElement(ElementName = "imageHasAnnotations")]
        public string ImageHasAnnotations { get; set; }
        [XmlElement(ElementName = "imageId")]
        public string ImageId { get; set; }
        [XmlElement(ElementName = "imageStatus")]
        public string ImageStatus { get; set; }
        [XmlElement(ElementName = "imageType")]
        public string ImageType { get; set; }
        [XmlElement(ElementName = "imageViewStatus")]
        public string ImageViewStatus { get; set; }
        [XmlElement(ElementName = "referenceImageUri")]
        public string ReferenceImageUri { get; set; }
        [XmlElement(ElementName = "sensitive")]
        public string Sensitive { get; set; }
        [XmlElement(ElementName = "thumbnailImageUri")]
        public string ThumbnailImageUri { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "study")]
    public class Study
    {
        [XmlElement(ElementName = "awivParameters")]
        public string AwivParameters { get; set; }
        [XmlElement(ElementName = "captureDate")]
        public string CaptureDate { get; set; }
        [XmlElement(ElementName = "capturedBy")]
        public string CapturedBy { get; set; }
        [XmlElement(ElementName = "cptCode")]
        public string CptCode { get; set; }
        [XmlElement(ElementName = "description")]
        public string Description { get; set; }
        [XmlElement(ElementName = "event")]
        public string Event { get; set; }
        [XmlElement(ElementName = "firstImage")]
        public FirstImage FirstImage { get; set; }
        [XmlElement(ElementName = "firstImageId")]
        public string FirstImageId { get; set; }
        [XmlElement(ElementName = "imageCount")]
        public int ImageCount { get; set; }
        [XmlElement(ElementName = "package")]
        public string Package { get; set; }
        [XmlElement(ElementName = "type")]
        public string Type { get; set; }
        [XmlElement(ElementName = "noteTitle")]
        public string NoteTitle { get; set; }
        [XmlElement(ElementName = "origin")]
        public string Origin { get; set; }
        [XmlElement(ElementName = "patientId")]
        public string PatientId { get; set; }
        [XmlElement(ElementName = "patientName")]
        public string PatientName { get; set; }
        [XmlElement(ElementName = "procedureDate")]
        public string ProcedureDate { get; set; }
        [XmlElement(ElementName = "procedureDescription")]
        public string ProcedureDescription { get; set; }
        [XmlElement(ElementName = "sensitive")]
        public string Sensitive { get; set; }
        [XmlElement(ElementName = "siteAbbreviation")]
        public string SiteAbbreviation { get; set; }
        [XmlElement(ElementName = "siteName")]
        public string SiteName { get; set; }
        [XmlElement(ElementName = "siteNumber")]
        public string SiteNumber { get; set; }
        [XmlElement(ElementName = "specialtyDescription")]
        public string SpecialtyDescription { get; set; }
        [XmlElement(ElementName = "studyCanHaveReport")]
        public string StudyCanHaveReport { get; set; }
        [XmlElement(ElementName = "studyClass")]
        public string StudyClass { get; set; }
        [XmlElement(ElementName = "studyHasImageGroup")]
        public string StudyHasImageGroup { get; set; }
        [XmlElement(ElementName = "studyId")]
        public string StudyId { get; set; }
        [XmlElement(ElementName = "studyImagesHaveAnnotations")]
        public string StudyImagesHaveAnnotations { get; set; }
        [XmlElement(ElementName = "studyPackage")]
        public string StudyPackage { get; set; }
        [XmlElement(ElementName = "studyStatus")]
        public string StudyStatus { get; set; }
        [XmlElement(ElementName = "studyType")]
        public string StudyType { get; set; }
        [XmlElement(ElementName = "studyViewStatus")]
        public string StudyViewStatus { get; set; }
        [XmlElement(ElementName = "serieses")]
        public Serieses Serieses { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "studies")]
    public class Studies
    {
        [XmlElement(ElementName = "study")]
        public List<Study> Study { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "studiesResult")]
    public class StudiesResult
    {
        [XmlElement(ElementName = "errors")]
        public string Errors { get; set; }
        [XmlElement(ElementName = "partialResult")]
        public string PartialResult { get; set; }
        [XmlElement(ElementName = "studies")]
        public Studies Studies { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "serieses")]
    public class Serieses
    {
        [XmlElement(ElementName = "series")]
        public List<Series> Series { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "series")]
    public class Series
    {
        [XmlElement(ElementName = "seriesNumber")]
        public string SeriesNumber { get; set; }

        [XmlElement(ElementName = "seriesUid")]
        public string SeriesUid { get; set; }

        [XmlElement(ElementName = "modality")]
        public string Modality { get; set; }

        [XmlElement(ElementName = "images")]
        public Images Images { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "images")]
    public class Images
    {
        [XmlElement(ElementName = "image")]
        public List<Image> Image { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "image")]
    public class Image
    {
        [XmlElement(ElementName = "associatedNoteResulted")]
        public string AssociatedNoteResulted { get; set; }
        [XmlElement(ElementName = "captureDate")]
        public string CaptureDate { get; set; }
        [XmlElement(ElementName = "diagnosticImageUri")]
        public string DiagnosticImageUri { get; set; }
        [XmlElement(ElementName = "dicomImageNumber")]
        public string DicomImageNumber { get; set; }
        [XmlElement(ElementName = "dicomSequenceNumber")]
        public string DicomSequenceNumber { get; set; }
        [XmlElement(ElementName = "dicomUid")]
        public DicomUid DicomUid { get; set; }
        [XmlElement(ElementName = "imageHasAnnotations")]
        public string ImageHasAnnotations { get; set; }
        [XmlElement(ElementName = "imageId")]
        public string ImageId { get; set; }
        [XmlElement(ElementName = "imageStatus")]
        public string ImageStatus { get; set; }
        [XmlElement(ElementName = "imageType")]
        public string ImageType { get; set; }
        [XmlElement(ElementName = "imageViewStatus")]
        public string ImageViewStatus { get; set; }
        [XmlElement(ElementName = "referenceImageUri")]
        public string ReferenceImageUri { get; set; }
        [XmlElement(ElementName = "sensitive")]
        public string Sensitive { get; set; }
        [XmlElement(ElementName = "thumbnailImageUri")]
        public string ThumbnailImageUri { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "site")]
    public class Site
    {
        [XmlElement(ElementName = "siteAbbr")]
        public string SiteAbbr { get; set; }
        [XmlElement(ElementName = "connections")]
        public Connections Connections { get; set; }
        [XmlElement(ElementName = "siteName")]
        public string SiteName { get; set; }
        [XmlElement(ElementName = "siteNumber")]
        public string SiteNumber { get; set; }
        [XmlElement(ElementName = "sitePatientLookupable")]
        public bool SitePatientLookupable { get; set; }
        [XmlElement(ElementName = "siteUserAuthenticatable")]
        public bool SiteUserAuthenticatable { get; set; }
        [XmlElement(ElementName = "visnNumber")]
        public string VisnNumber { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "connections")]
    public class Connections
    {
        [XmlElement(ElementName = "connection")]
        public List<Connection> Connection { get; set; }
    }

    [Serializable]
    [XmlRoot(ElementName = "connection")]
    public class Connection
    {
        [XmlElement(ElementName = "port")]
        public string Port { get; set; }
        [XmlElement(ElementName = "protocol")]
        public string Protocol { get; set; }
        [XmlElement(ElementName = "server")]
        public string Server { get; set; }
    }
}